/*
  	File:       PID.h

	DRI: George Warner
 
	Contains:   Definition of the PID constants (NOTE: Moved into <IOKit/hid/IOHIDUsageTables.h>)
    
	DRI: George Warner

	Copyright:	Copyright  2002 Apple Computer, Inc., All Rights Reserved

	Disclaimer:	IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
				("Apple") in consideration of your agreement to the following terms, and your
				use, installation, modification or redistribution of this Apple software
				constitutes acceptance of these terms.  If you do not agree with these terms,
				please do not use, install, modify or redistribute this Apple software.

				In consideration of your agreement to abide by the following terms, and subject
				to these terms, Apple grants you a personal, non-exclusive license, under Apples
				copyrights in this original Apple software (the "Apple Software"), to use,
				reproduce, modify and redistribute the Apple Software, with or without
				modifications, in source and/or binary forms; provided that if you redistribute
				the Apple Software in its entirety and without modifications, you must retain
				this notice and the following text and disclaimers in all such redistributions of
				the Apple Software.  Neither the name, trademarks, service marks or logos of
				Apple Computer, Inc. may be used to endorse or promote products derived from the
				Apple Software without specific prior written permission from Apple.  Except as
				expressly stated in this notice, no other rights or licenses, express or implied,
				are granted by Apple herein, including but not limited to any patent rights that
				may be infringed by your derivative works or by other works in which the Apple
				Software may be incorporated.

				The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
				WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
				WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
				COMBINATION WITH YOUR PRODUCTS.

				IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
				CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
				GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
				ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
				OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
				(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
				ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef __PID__
#define __PID__

#ifdef __cplusplus
extern "C"
{
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

/* Physical Interface Device Page (0x0F) */
/* This section provides detailed descriptions of the usages employed by Digitizer Devices. */
enum
{
	kHIDUsage_PID_PhysicalInterfaceDevice = 0x01,		/* CA - A collection of PID usages */
	/* 0x02 - 0x1F Reserved */
	kHIDUsage_PID_Normal = 0x20,						/* DV - A force applied perpendicular to the surface of an object */
	kHIDUsage_PID_SetEffectReport = 0x21,				/* XXX */
	kHIDUsage_PID_EffectBlockIndex = 0x22,				/* XXX */
	kHIDUsage_PID_ParamBlockOffset = 0x23,				/* XXX */
	kHIDUsage_PID_ROM_Flag = 0x24,						/* XXX */
	kHIDUsage_PID_EffectType = 0x25,					/* XXX */
	kHIDUsage_PID_ET_ConstantForce = 0x26,				/* XXX */
	kHIDUsage_PID_ET_Ramp = 0x27,						/* XXX */
	kHIDUsage_PID_ET_CustomForceData = 0x28,			/* XXX */
	/* 0x29 - 0x2F Reserved */
	kHIDUsage_PID_ET_Square = 0x30,						/* XXX */
	kHIDUsage_PID_ET_Sine = 0x31,						/* XXX */
	kHIDUsage_PID_ET_Triangle = 0x32,					/* XXX */
	kHIDUsage_PID_ET_SawtoothUp = 0x33,					/* XXX */
	kHIDUsage_PID_ET_SawtoothDown = 0x34,				/* XXX */
	/* 0x35 - 0x3F Reserved */
	kHIDUsage_PID_ET_Spring = 0x40,						/* XXX */
	kHIDUsage_PID_ET_Damper = 0x41,						/* XXX */
	kHIDUsage_PID_ET_Inertia = 0x42,					/* XXX */
	kHIDUsage_PID_ET_Friction = 0x43,					/* XXX */
	/* 0x44 - 0x4F Reserved */
	kHIDUsage_PID_Duration = 0x50,						/* XXX */
	kHIDUsage_PID_SamplePeriod = 0x51,					/* XXX */
	kHIDUsage_PID_Gain = 0x52,							/* XXX */
	kHIDUsage_PID_TriggerButton = 0x53,					/* XXX */
	kHIDUsage_PID_TriggerRepeatInterval = 0x54,			/* XXX */
	kHIDUsage_PID_AxesEnable = 0x55,					/* XXX */
	kHIDUsage_PID_DirectionEnable = 0x56,				/* XXX */
	kHIDUsage_PID_Direction = 0x57,						/* XXX */
	kHIDUsage_PID_TypeSpecificBlockOffset = 0x58,		/* XXX */
	kHIDUsage_PID_BlockType = 0x59,						/* XXX */
	kHIDUsage_PID_SetEnvelopeReport = 0x5A,				/* XXX */
	kHIDUsage_PID_AttackLevel = 0x5B,					/* XXX */
	kHIDUsage_PID_AttackTime = 0x5C,					/* XXX */
	kHIDUsage_PID_FadeLevel = 0x5D,						/* XXX */
	kHIDUsage_PID_FadeTime = 0x5E,						/* XXX */
	kHIDUsage_PID_SetConditionReport = 0x5F,			/* XXX */

	kHIDUsage_PID_CP_Offset = 0x60,						/* XXX */
	kHIDUsage_PID_PositiveCoefficient = 0x61,			/* XXX */
	kHIDUsage_PID_NegativeCoefficient = 0x62,			/* XXX */
	kHIDUsage_PID_PositiveSaturation = 0x63,			/* XXX */
	kHIDUsage_PID_NegativeSaturation = 0x64,			/* XXX */
	kHIDUsage_PID_DeadBand = 0x65,						/* XXX */
	kHIDUsage_PID_DownloadForceSample = 0x66,			/* XXX */
	kHIDUsage_PID_IsochCustomForceEnable = 0x67,		/* XXX */
	kHIDUsage_PID_CustomForceDataReport = 0x68,			/* XXX */
	kHIDUsage_PID_CustomForceData = 0x69,				/* XXX */
	kHIDUsage_PID_CustomForceVendorDefinedData = 0x6A,	/* XXX */
	kHIDUsage_PID_SetCustomForceReport = 0x6B,			/* XXX */
	kHIDUsage_PID_CustomForceDataOffset = 0x6C,			/* XXX */
	kHIDUsage_PID_SampleCount = 0x6D,					/* XXX */
	kHIDUsage_PID_SetPeriodicReport = 0x6E,				/* XXX */
	kHIDUsage_PID_Offset = 0x6F,						/* XXX */

	kHIDUsage_PID_Magnitude = 0x70,						/* XXX */
	kHIDUsage_PID_Phase = 0x71,							/* XXX */
	kHIDUsage_PID_Period = 0x72,						/* XXX */
	kHIDUsage_PID_SetConstantForceReport = 0x73,		/* XXX */
	kHIDUsage_PID_SetRampForceReport = 0x74,			/* XXX */
	kHIDUsage_PID_RampStart = 0x75,						/* XXX */
	kHIDUsage_PID_RampEnd = 0x76,						/* XXX */
	kHIDUsage_PID_EffectOperationReport = 0x77,			/* XXX */
	kHIDUsage_PID_EffectOperation = 0x78,				/* XXX */
	kHIDUsage_PID_OpEffectStart = 0x79,					/* XXX */
	kHIDUsage_PID_OpEffectStartSolo = 0x7A,				/* XXX */
	kHIDUsage_PID_OpEffectStop = 0x7B,					/* XXX */
	kHIDUsage_PID_LoopCount = 0x7C,						/* XXX */
	kHIDUsage_PID_DeviceGainReport = 0x7D,				/* XXX */
	kHIDUsage_PID_DeviceGain = 0x7E,					/* XXX */
	kHIDUsage_PID_PoolReport = 0x7F,					/* XXX */

	kHIDUsage_PID_RAM_PoolSize = 0x80,					/* XXX */
	kHIDUsage_PID_ROM_PoolSize = 0x81,					/* XXX */
	kHIDUsage_PID_ROM_EffectBlockCount = 0x82,			/* XXX */
	kHIDUsage_PID_SimultaneousEffectsMax = 0x83,		/* XXX */
	kHIDUsage_PID_PoolAlignment = 0x84,					/* XXX */
	kHIDUsage_PID_PoolMoveReport = 0x85,				/* XXX */
	kHIDUsage_PID_MoveSource = 0x86,					/* XXX */
	kHIDUsage_PID_MoveDestination = 0x87,				/* XXX */
	kHIDUsage_PID_MoveLength = 0x88,					/* XXX */
	kHIDUsage_PID_BlockLoadReport = 0x89,				/* XXX */
	/* 0x8A Reserved */
	kHIDUsage_PID_BlockLoadStatus = 0x8B,				/* XXX */
	kHIDUsage_PID_BlockLoadSuccess = 0x8C,				/* XXX */
	kHIDUsage_PID_BlockLoadFull = 0x8D,					/* XXX */
	kHIDUsage_PID_BlockLoadError = 0x8E,				/* XXX */
	kHIDUsage_PID_BlockHandle = 0x8F,					/* XXX */

	kHIDUsage_PID_BlockFreeReport = 0x90,				/* XXX */
	kHIDUsage_PID_TypeSpecificBlockHandle = 0x91,		/* XXX */
	kHIDUsage_PID_StateReport = 0x92,					/* XXX */
	/* 0x93 Reserved */
	kHIDUsage_PID_EffectPlaying = 0x94,					/* XXX */
	kHIDUsage_PID_DeviceControlReport = 0x95,			/* XXX */
	kHIDUsage_PID_DeviceControl = 0x96,					/* XXX */
	kHIDUsage_PID_DC_EnableActuators = 0x97,			/* XXX */
	kHIDUsage_PID_DC_DisableActuators = 0x98,			/* XXX */
	kHIDUsage_PID_DC_StopAllEffects = 0x99,				/* XXX */
	kHIDUsage_PID_DC_DeviceReset = 0x9A,				/* XXX */
	kHIDUsage_PID_DC_DevicePause = 0x9B,				/* XXX */
	kHIDUsage_PID_DC_DeviceContinue = 0x9C,				/* XXX */
	/* 0x9d - 0x9E Reserved */
	kHIDUsage_PID_DevicePaused = 0x9F,					/* XXX */

	kHIDUsage_PID_ActuatorsEnabled = 0xA0,				/* XXX */
	/* 0xA1 - 0xA3 Reserved */
	kHIDUsage_PID_SafetySwitch = 0xA4,					/* XXX */
	kHIDUsage_PID_ActuatorOverrideSwitch = 0xA5,		/* XXX */
	kHIDUsage_PID_ActuatorPower = 0xA6,					/* XXX */
	kHIDUsage_PID_StartDelay = 0xA7,					/* XXX */
	kHIDUsage_PID_ParameterBlockSize = 0xA8,			/* XXX */
	kHIDUsage_PID_DeviceManagedPool = 0xA9,				/* XXX */
	kHIDUsage_PID_SharedParameterBlocks = 0xAA,			/* XXX */
	kHIDUsage_PID_CreateNewEffectReport = 0xAB,			/* XXX */
	kHIDUsage_PID_RAM_PoolAvailable = 0xAC,				/* XXX */
	/* 0xAD - 0xFFFF Reserved */
	kHIDUsage_PID_Reserved = 0xFFFF
};
	
#ifdef __cplusplus
}
#endif

#endif /* __PID__ */

